%------------------------------------------------------------------------------
% File     : CSR121^1 : TPTP v9.2.0. Released v4.1.0.
% Domain   : Commonsense Reasoning
% Problem  : Did Mary and Sue like someone in 2009?
% Version  : Especial.
% English  : During 2009 Mary liked Bill and Sue liked Bill (formulated via 
%            de-Morgan rule instead of a simply using and). Does someone exist 
%            who was liked by Mary and Sue during 2009?

% Refs     : [Ben10] Benzmueller (2010), Email to Geoff Sutcliffe
% Source   : [Ben10]
% Names    : ef_3.tq_SUMO_local [Ben10]

% Status   : Theorem
% Rating   : 0.08 v9.1.0, 0.12 v9.0.0, 0.08 v8.2.0, 0.09 v8.1.0, 0.08 v7.4.0, 0.11 v7.3.0, 0.10 v7.2.0, 0.12 v7.1.0, 0.14 v7.0.0, 0.12 v6.4.0, 0.14 v6.3.0, 0.17 v6.2.0, 0.00 v6.1.0, 0.50 v6.0.0, 0.00 v5.3.0, 0.25 v4.1.0
% Syntax   : Number of formulae    :   10 (   0 unt;   8 typ;   0 def)
%            Number of atoms       :    9 (   0 equ;   3 cnn)
%            Maximal formula atoms :    6 (   4 avg)
%            Number of connectives :   22 (   3   ~;   1   |;   1   &;  17   @)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    7 (   7 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :    5 (   5   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    8 (   7 usr;   5 con; 0-2 aty)
%            Number of variables   :    1 (   0   ^;   0   !;   1   ?;   1   :)
% SPC      : TH0_THM_NEQ_NAR

% Comments : This is a simple test problem for reasoning in/about SUMO.
%            Initally the problem has been hand generated in KIF syntax in
%            SigmaKEE and then automatically translated by Benzmueller's
%            KIF2TH0 translator into THF syntax.
%          : The translation has been applied in two modes: local and SInE.
%            The local mode only translates the local assumptions and the
%            query. The SInE mode additionally translates the SInE-extract
%            of the loaded knowledge base (usually SUMO).
%          : The examples are selected to illustrate the benefits of
%            higher-order reasoning in ontology reasoning.
%------------------------------------------------------------------------------
%----The extracted signature
thf(numbers,type,
    num: $tType ).

thf(holdsDuring_THFTYPE_IiooI,type,
    holdsDuring_THFTYPE_IiooI: $i > $o > $o ).

thf(lBill_THFTYPE_i,type,
    lBill_THFTYPE_i: $i ).

thf(lMary_THFTYPE_i,type,
    lMary_THFTYPE_i: $i ).

thf(lSue_THFTYPE_i,type,
    lSue_THFTYPE_i: $i ).

thf(lYearFn_THFTYPE_IiiI,type,
    lYearFn_THFTYPE_IiiI: $i > $i ).

thf(likes_THFTYPE_IiioI,type,
    likes_THFTYPE_IiioI: $i > $i > $o ).

thf(n2009_THFTYPE_i,type,
    n2009_THFTYPE_i: $i ).

%----The translated axioms
thf(ax,axiom,
    ( holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i )
    @ ( (~)
      @ ( ( (~) @ ( likes_THFTYPE_IiioI @ lMary_THFTYPE_i @ lBill_THFTYPE_i ) )
        | ( (~) @ ( likes_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBill_THFTYPE_i ) ) ) ) ) ).

%----The translated conjecture
thf(con,conjecture,
    ? [X: $i] :
      ( holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i )
      @ ( ( likes_THFTYPE_IiioI @ lMary_THFTYPE_i @ X )
        & ( likes_THFTYPE_IiioI @ lSue_THFTYPE_i @ X ) ) ) ).

%------------------------------------------------------------------------------
